import random
#####################
#       *           #
#      / \          #
#     /   \         #
#    /_____\        #
#      / \          #
#     /   \         #
#    /_____\        #
#      / \          #
#     /   \         #
#    /_____\        #
#      | |          #
#      |_|          #
#  MERRY CHRISTMAS! #
#####################
#
# Welcome to the Christmas Coding Club
# Have a play around with Christmas trees in turtle. You might use the one I
# made to help you or make your own. Extra cake to the best one!
#

from turtle import *
penup()
speed(100)
goto(0,250)#Puts the turtle where we can see it.
start = pos() #This creates a variable called 'start' and tells us where the turtle's starting point is. 


#Create functions to draw triangles on the left and right hand side of the tree. 
def drawRightBranches(x): #draws the right hand side of the tree
    begin_fill() #starts the fill
    color(random.choice(['darkgreen'])) #sets wanted colour randomly
    pendown()
    right(60)
    forward(x/2) #drawing the side of the tree
    right(120)
    forward(x/4) #goes back to middle of the tree
    right(90)
    forward(x/4) #goes up into the triangle to start the next one. Makes it look like a tree.
    right(90)
    end_fill() #puts in the nice green colour.
    penup() #takes pen off page
    pass

def drawLeftBranches(x): #draws the left hand side of the tree.
    begin_fill() #starts the fill
    color(random.choice(['darkgreen'])) #sets wanted colour.
    pendown()
    left(60)
    forward(x/2) #drawing the side of the tree
    left(120)
    forward(x/4) #goes back to middle of the tree
    left(90)
    forward(x/4) #goes up into the triangle to start the next one. Makes it look like a tree.
    left(90)
    end_fill() #puts in the nice green colour.
    penup() #takes pen off page
    pass

#Main programme...

n = 500
l = 3

for x in range(l): #we want three layers
    drawRightBranches(n) #calls function which draws right branches
    pass

#Re-aligning the turtle to draw the left side of the tree.
penup() #stops writing while we go back to the start to do the left hand side.
goto(start) #does what it says on the tin...
left(180) #align the turtle ready for the left hand side.

for x in range(l): #we want three layers
    drawLeftBranches(n) #calls function which draws left branches
    pass


#Some things you can do now (if you want):
#   - Add a brown stump to the bottom
#   - Add some more layers
#   - Add some decorations
#
#FYI: Top of the tree is (0,250) and each layer is 216.5 units tall.
#If you've changed the value of n, then you can calculate the height using h = (n(l * sqrt(3)-l+1))/4
#sqrt(3) = 1.732

#the sky is the limit...

h = (n*(l * 1.732)-l+1)/4

goto(start)
left(90)
forward(400)
color('brown')
right(90)
forward(n/10)
left(90)
begin_fill()
forward(n/4)
left(90)
forward(n/5)
left(90)
forward(n/4)
left(90)
forward(n/10)
end_fill()
penup()

goto(start)

#https://www.tcl.tk/man/tcl8.4/TkCmd/colors.htm

